// VERSION: Scilab: 5.5.2 
// OS: windows 7 
// CAPTION: DC motor Response


clc;
clear;
format('v',7)
// given data :
V=input('Enter the value of voltage:');// enter 230vs
Vm=sqrt(2)*V; // in volts
Ka=input('Enter the value of ka:'); // enter Ka = 1;
QR=input('Enter the value of QR:');// enter QR = 1;
Ra=input('Enter the value of Ra:');// enter Ra = 0.05
Alpha=input('Enter the angle');// enter angle = 30 (in degree)
Y=(60/(2*%pi)); //
Z=((Vm/%pi)*(1+cosd(Alpha))); //
X=(Ra/(0.5)^2)
for i=1:8
Wm(i)= (Z -(i)*X)*Y; //
end
Wm=[(Y*Z);Wm(1);Wm(2);Wm(3);Wm(4);Wm(5);Wm(6);Wm(7);
Wm(8)]
disp(Wm ," Varoius values of speed in RPM is ")
T=[0;1;2;3;4;5;6;7;8];
plot2d(T,Wm)
xlabel("Torque ,N*m")
ylabel(" Speed ( rpm) for alpha=30 degree ")

// ==  Sample output ===//

//Enter the value of voltage:230
//Enter the value of ka:1
//Enter the value of QR:1
//Enter the value of ra:0.05
//Enter the angle30
 
//  Varoius values of speed in RPM is    
 
 //   1844.9  
 //   1843.   
 //   1841.1  
 ///   1839.2  
 //   1837.3  
 //   1835.4  
 //   1833.5  
 //   1831.6  
 //   1829.7  
  
